function setParam(ssm, name, val)
%SETPARAM Change a value of a parameter in a StateSpaceModel object
% If a DynamicElement of 'ssm.p.<name>' exists, its value will change to
% the given val. Otherwise an error will be thrown.
% Inputs:
%   ssm - A StateSpaceModel object
%   def - The name of the parameter to be change
%   val - The new value that the parameter recieves

% David Katzin, Wageningen University
% david.katzin@wur.nl

    if ~isfield(ssm.p,name)
        error('The given model has no parameter named %s.', name);
    end
    
    if ~isnumeric(val)
        error('The given value must be numeric.');
    end

    ssm.p.(name).val = val;
    ssm.p.(name).func = val;
end

